<?php
/**
 * Module Name: WP-Courseware Integration
 */

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

if ( function_exists( 'WPCW_plugin_init' ) ) :

 //*************** Actions ***************\\
 add_action('wpcw_quiz_graded', 'wpachievements_wpcw_quiz_complete', 10, 3);
 add_action('wpcw_user_completed_module', 'wpachievements_wpcw_module_complete', 10, 2);
 add_action('wpcw_user_completed_course', 'wpachievements_wpcw_course_complete', 10, 3);
 //*************** Detect Quiz Completed ***************\\
 function wpachievements_wpcw_quiz_complete($userID, $quizDetails, $correctPercentage){
   if(!empty($userID)){
     if($quizDetails->quiz_id){
       $postid = $quizDetails->quiz_id;
     } else{
       $postid = '';
     }
      WPAchievements_Trigger::new_activity( array(
        'activity'    => 'wpcw_quiz_pass',
        'user_id'     => $userID,
        'post_id'     => $postid,
        'points'      => (int) wpachievements_get_site_option('wpachievements_wpcw_quiz_pass'),
      ) );
     if($correctPercentage == '100'){
      WPAchievements_Trigger::new_activity( array(
        'activity'    => 'wpcw_quiz_perfect',
        'user_id'     => $userID,
        'post_id'     => $postid,
        'points'      => (int) wpachievements_get_site_option('wpachievements_wpcw_quiz_perfect'),
      ) );       
     }
   }
 }
 //*************** Detect Module Completed ***************\\
 function wpachievements_wpcw_module_complete($userID, $unitID){
   if(!empty($userID)){
    WPAchievements_Trigger::new_activity( array(
      'activity'    => 'wpcw_module_complete',
      'user_id'     => $userID,
      'post_id'     => $unitID,
      'points'      => (int) wpachievements_get_site_option('wpachievements_wpcw_module_complete'),
    ) );        
   }
 }
 //*************** Detect Course Completed ***************\\
 function wpachievements_wpcw_course_complete($userID, $unitID, $unitParentData){
   if(!empty($userID)){
     if($unitParentData->course_id){
       $postid = $unitParentData->course_id;
     } else{
       $postid = '';
     }
      WPAchievements_Trigger::new_activity( array(
        'activity'    => 'wpcw_course_complete',
        'user_id'     => $userID,
        'post_id'     => $postid,
        'points'      => (int) wpachievements_get_site_option('wpachievements_wpcw_course_complete'),
      ) );        
   }
 }

 //*************** Descriptions ***************\\
 add_filter('wpachievements_activity_description', 'achievement_wpcw_desc', 10, 4);
 function achievement_wpcw_desc($text='',$type='',$points='',$times=''){
  switch($type){
   case 'wpcw_quiz_pass': { $text = sprintf( _n( 'for passing %s quiz', 'for passing %s quizzes', $times, 'wpachievements'), $times ); } break;
   case 'wpcw_quiz_perfect': { $text = sprintf( _n( 'for getting %s perfect score', 'for getting %s perfect scores', $times, 'wpachievements'), $times ); } break;
   case 'wpcw_module_complete': { $text = sprintf( _n( 'for completing %s module', 'for completing %s modules', $times, 'wpachievements'), $times ); } break;
   case 'wpcw_course_complete': { $text = sprintf( _n( 'for completing %s course', 'for completing %s courses', $times, 'wpachievements'), $times ); } break;
  }
  return $text;
 }

 //*************** Descriptions ***************\\
 add_filter('wpachievements_quest_description', 'quest_wpcw_desc', 10, 3);
 function quest_wpcw_desc($text='',$type='',$times=''){
  switch($type){
   case 'wpcw_quiz_pass': { $text = sprintf( _n( 'Pass %s quiz', 'Pass %s quizzes', $times, 'wpachievements'), $times ); } break;
   case 'wpcw_quiz_perfect': { $text = sprintf( _n( 'Get %s perfect score', 'Get %s perfect scores', $times, 'wpachievements'), $times ); } break;
   case 'wpcw_module_complete': { $text = sprintf( _n( 'Complete %s module', 'Complete %s modules', $times, 'wpachievements'), $times ); } break;
   case 'wpcw_course_complete': { $text = sprintf( _n( 'Complete %s course', 'Complete %s courses', $times, 'wpachievements'), $times ); } break;
  }
  return $text;
 }

add_filter( 'wpachievements_get_sections_module', 'wpachievements_add_section_wpcw' );
function wpachievements_add_section_wpcw( $sections ) {
	$sections['wpcw'] = __( 'WP-Courseware', 'wpachievements' );
	return $sections;
}

//*************** Admin Settings ***************\\
add_filter('wpachievements_achievements_modules_admin_settings', 'wpachievements_wpcw_admin', 10, 3);
function wpachievements_wpcw_admin($defaultsettings, $shortname, $current_section){
  if ( $current_section == 'wpcw' ) {
    $settings[] = array( 'title' => __( 'WP-Courseware', 'wpachievements' ), 'type' => 'title', 'desc' => '', 'id' => 'WPCourseware_options' );

    $settings[] = array(
            'title'   => __( 'User Passes Quiz', 'wpachievements' ),
            'desc'    => __( 'Points awarded when a user passes a quiz.', 'wpachievements' ),
            'id'      => $shortname.'_wpcw_quiz_pass',
            'type'    => 'text',
            'default' => '0',
          );

    $settings[] = array(
            'title'   => __( 'User Gets Perfect Quiz Score', 'wpachievements' ),
            'desc'    => __( 'Points awarded when a user gets 100% on a quiz.', 'wpachievements' ),
            'id'      => $shortname.'_wpcw_quiz_perfect',
            'type'    => 'text',
            'default' => '0',
          );

    $settings[] = array(
            'title'   => __( 'User Completes Module', 'wpachievements' ),
            'desc'    => __( 'Points awarded when a user completes a module.', 'wpachievements' ),
            'id'      => $shortname.'_wpcw_module_complete',
            'type'    => 'text',
            'default' => '0',
          );

    $settings[] = array(
            'title'   => __( 'Users Completes Course.', 'wpachievements' ),
            'desc'    => __( 'Points awarded when a user completes a course.', 'wpachievements' ),
            'id'      => $shortname.'_wpcw_course_complete',
            'type'    => 'text',
            'default' => '0',
          );

    $settings[] = array( 'type' => 'sectionend', 'id' => 'WPCourseware_options');

    return $settings;
/**
  * If not, return the standard settings
  **/
	} else {
		return $defaultsettings;
	}
}

 //*************** Admin Events ***************\\
 add_filter('wpachievements_admin_events', 'achievement_wpcw_admin_events', 10);
 function achievement_wpcw_admin_events(){
   echo'<optgroup label="WP-Courseware Events">
     <option value="wpcw_quiz_pass">'.__('The user passes a quiz', 'wpachievements').'</option>
     <option value="wpcw_quiz_perfect">'.__('The user gets 100% on a quiz', 'wpachievements').'</option>
     <option value="wpcw_module_complete">'.__('The user completes a module', 'wpachievements').'</option>
     <option value="wpcw_course_complete">'.__('The user completes a course', 'wpachievements').'</option>
   </optgroup>';
 }

 //*************** Admin Trigger Naming ***************\\
 add_filter('wpachievements_trigger_description', 'achievement_wpcw_admin_triggers', 1, 10);
 function achievement_wpcw_admin_triggers($trigger){

   switch($trigger){
     case 'wpcw_quiz_pass': { $trigger = __('The user passes a quiz', 'wpachievements'); } break;
     case 'wpcw_quiz_perfect': { $trigger = __('The user gets 100% on a quiz', 'wpachievements'); } break;
     case 'wpcw_module_complete': { $trigger = __('The user completes a module', 'wpachievements'); } break;
     case 'wpcw_course_complete': { $trigger = __('The user completes a course', 'wpachievements'); } break;
   }

   return $trigger;
 }
endif;
?>